 ; Ŀ
 ;   Rat: make text into attdefs.                                          
 ;   Copyright 1992, 2001 by Rocket Software Ltd.                          
 ;   AutoCAD: a group of commands which enable a computer to convert       
 ;   a series of hand movements into a pattern of light waves.             
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string at a given character, make    
 ;   into a list of substrings.                                            
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (and (/= linn "")
                     (= (substr linn (setq len (strlen linn))) " "))
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (and (/= name1 "")
                     (= (substr name1 (setq len (strlen name1))) " "))
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Rat.                                                                  
 ; 
 (DEFUN C:RAT (/ nn tt fh bb bent altr spoft pflag vflag cflag iflag chg onoff
                                   txtstr def1 tag2p tag2 prompt3 aa bbf asoc)
  (setvar "cmdecho" 0)
  (command "undo" "mark")
  (setq tt (getvar "textstyle"))                         ; get style
  (setq fh (cdr (assoc 40 (tblsearch "style" tt))))      ; fixed height?
  (setq bb (entget (setq bent (car (entsel "Text to convert to an attdef:\n")))))
  (if (/= (cdr (assoc 0 bb)) "TEXT")
      (prompt "\nText: it pretty well has to be text.")
      (progn
 ; Ŀ
 ;   Figure which of ICVP is set, set flags and make a text string.        
 ; 
           (setq altr (setq spoft (getvar "aflags")))
           (if (= (/ spoft 8) 1) (setq pflag "P") (setq pflag "p"))
           (setq spoft (rem spoft 8))
           (if (= (/ spoft 4) 1) (setq vflag "V") (setq vflag "v"))
           (setq spoft (rem spoft 4))
           (if (= (/ spoft 2) 1) (setq cflag "C") (setq cflag "c"))
           (setq spoft (rem spoft 2))
           (if (= (/ spoft 1) 1) (setq iflag "I") (setq iflag "i"))
           (setq spoft (strcat iflag cflag vflag pflag))
           (setq chg (getstring (strcat "Current settings: " spoft
                                        "  Do you wish to alter them? <N>: ")))
           (if (or (= (strcase chg) "Y") (= (strcase chg) "YES"))
 ; Ŀ
 ;   Change ICVP settings if desired; update Constant flag if required.    
 ; 
              (progn
                   (write-line 
                   "<Enter> to keep current setting, any character to toggle.")
                   (if (= iflag "i") (setq onoff "Off") (setq onoff "On"))
                   (if (/= "" (Getstring (strcat 
                                   "New setting for Invisible <" onoff ">: ")))
                       (if (= onoff "On")
                           (setq altr (- altr 1))
                           (setq altr (+ altr 1))))
                   (if (= cflag "c") (setq onoff "Off") (setq onoff "On"))
                   (if (/= "" (Getstring (strcat
                                    "New setting for Constant <" onoff ">: ")))
                       (progn
                            (if (= onoff "On")
                                (setq altr (- altr 2))
                                (setq altr (+ altr 2)))
                            (if (= cflag "c")
                                (setq cflag "C")
                                (setq cflag "c"))))
                   (if (= vflag "v") (setq onoff "Off") (setq onoff "On"))
                   (if (/= "" (Getstring (strcat
                                      "New setting for Verify <" onoff ">: ")))
                       (if (= onoff "On")
                           (setq altr (- altr 4))
                           (setq altr (+ altr 4))))
                   (if (= pflag "p") (setq onoff "Off") (setq onoff "On"))
                   (if (/= "" (Getstring (strcat
                                      "New setting for Preset <" onoff ">: ")))
                       (if (= onoff "On")
                           (setq altr (- altr 8))
                           (setq altr (+ altr 8))))
                   (setvar "aflags" altr)))
 ; Ŀ
 ;   Ask a Tag value - this can't be an empty string or contain a space.   
 ;   It will be uppercase...                                               
 ; 
           (setq txtstr (cdr (assoc 1 bb)))
           (setq tag2p (strcase (car (splat " " txtstr))))
           (setq tag2 (getstring (strcat "Attribute tag (" tag2p "): ")))
           (if (= tag2 "") (setq tag2 tag2p))
 ; Ŀ
 ;   Ask for a Prompt.                                                     
 ; 
           (setq prompt3 (getstring T (strcat "Prompt (" txtstr "): ")))
           (if (= prompt3 "") (setq prompt3 txtstr))
           (if (= prompt3 " ") (setq prompt3 ""))
 ; Ŀ
 ;   Ask for a Default value - use text string for the default default.    
 ; 
           (setq def1 (getstring T (strcat "Default value (" txtstr "): ")))
           (if (= def1 "") (setq def1 txtstr))
           (if (= def1 " ") (setq def1 ""))
 ; Ŀ
 ;   Check the Constant flag: no prompt is input for a const. attribute.   
 ;   The attdef command is one "" shorter if text style is fixed height.   
 ; 
           (if (= fh 0.0)                                       ; fixed height?
               (if (= cflag "C")
                   (command ".attdef" "" "." "" (getvar "viewctr") "" "")
                   (command ".attdef" "" "." "" "" (getvar "viewctr") "" ""))
               (if (= cflag "C")
                   (command ".attdef" "" "." "" (getvar "viewctr") "")
                   (command ".attdef" "" "." "" "" (getvar "viewctr") "")))
           (setq aa (entget (entlast)))
 ; Ŀ
 ;   Remanufacture the new attdef to match the text & inputs.              
 ; 
           (setq bbf (list (assoc -1 aa) (assoc 0 aa)
                           (cons 1 def1) (cons 2 tag2) (cons 3 prompt3)))
           (setq nn 0)
           (while (nth nn bb)
                  (setq asoc (car (nth nn bb)))
                  (cond ((not (or (= 0  asoc)
                                  (= 5  asoc)
                                  (= 1  asoc)
                                  (= -1 asoc)
                                  (= 2  asoc)
                                  (= 74 asoc)
                                  (= 73 asoc)))
                       (setq bbf (cons (nth nn bb) bbf)))
                      ((= 73 asoc)
                       (setq bbf (cons (cons 74 (cdr (nth nn bb))) bbf))))
                  (setq nn (1+ nn)))
           (setq bbf (reverse bbf))
 ; Ŀ
 ;   Delete the original text entity, rehash the new attdef.               
 ; 
           (entdel bent)
           (entmod bbf)))
  (princ))